function [obj] = brain_file_maker_edit_job_smooth_cortex_parm(obj, parm_type)
% edit vb_job_smooth_cortex parameter by gui
% [USAGE]
%    [obj] = brain_file_maker_edit_job_smooth_cortex_parm(<obj>, <parm_type>);
% [IN]
%          obj : brain_file_maker object
%    parm_type : edit parameter type
% [OUT]
%    obj : brain_file_maker object
%
% Author: rhayashi
% Created: 2007-07-25
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end

%
% --- Main Procedure
%
const = define_brain_file_maker;
switch(parm_type)
    case const.JOB_SMOOTH_CORTEX_PARM
        parm = job_smooth_cortex_parm_get_parm(obj.job_smooth_cortex_parm);
        caption = 'vb_job_smooth_cortex parameter';
    case  const.JOB_BRAIN_STD2BRAIN_PARM
        parm = job_brain_std2sbj_parm_get_parm(obj.job_brain_std2sbj_parm);
        caption = 'job_brain_std2_brain parameter';
end

[parm, cancelled] = vb_edit_struct(parm, caption);

if cancelled == false
    switch(parm_type)
        case  const.JOB_SMOOTH_CORTEX_PARM
            [obj.job_smooth_cortex_parm, result] = ...
                job_smooth_cortex_parm_set_parm(obj.job_smooth_cortex_parm, parm);
        case  const.JOB_BRAIN_STD2BRAIN_PARM
            [obj.job_brain_std2sbj_parm, result] = ...
                job_brain_std2sbj_parm_set_parm(obj.job_brain_std2sbj_parm, parm);
    end
    if result == FAILURE
        errordlg('Parameter is invalid.');
    end
end

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
