function [obj] = history_add_item_varg(obj, description, varargin)
% add item to history
% [USAGE]
%    [obj] = history_add_item_varg(<obj>, <description>[,var1][,var2][,...]);
% [IN]
%          obj : history object
%  description : <<string>> explanation of history
%  varargin    : variable argument
% [OUT]
%    obj : history object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('description', 'var');
    error('description is a required parameter.');
end
Nvarg = nargin - 2;
for k=3:nargin
    if isempty(inputname(k))
        error('Not variable was specified.');
    end
end

%
% --- Main Procedure
%
S = struct;

for k=3:nargin
    S.(inputname(k)) = varargin{k-2};
end

obj = history_add_item(obj, description, S);
