function [obj] = history_add_item(obj, description, parm)
% add item to history.
% [USAGE]
%    [obj] = history_add_history(<obj>, <description>[ ,parm]);
% [IN]
%            obj : history object
%    description : <<string>>    explanation of history
%           parm : <<structure>> parameter
% [OUT]
%    obj : history object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('description', 'var')
    error('description is a required parameter.');
end
if ~exist('parm', 'var')
    parm = [];
end


%
% --- Main Procedure
%
Nitem = history_get_length(obj);
item = struct;
item.description = description;
item.parm        = parm;
obj.item_list{Nitem+1} = item;

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
