function [Vorigin] = mask_image_data_get_Vorigin(obj)
% get mask image data
% [USAGE]
%    [Vorigin] = mask_image_data_get_Vorigin(<obj>);
% [IN]
%    obj : mask_image_data object
% [OUT]
%    Vorigin : origin of Voxel coordinate
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~strcmp(obj.class_type, 'mask_image_data')
    error('class type is invalid.');
end

%
% --- Main Procedure
%
Vorigin = obj.Vorigin;

