function [obj] = brain_data_set_model_name(obj, model_name)
% set model name to brain_data.
% [USAGE]
%    [obj] = brain_data_set_model_name(<obj>, <model_name>);
% [IN]
%           obj : brain_data object
%    model_name : model name
% [OUT]
%    obj : brain_data object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('model_name', 'var')
    error('model_name is a required parameter.');
end

%
% --- Main Procedure
%

obj.model_name = model_name;

%
% --- After check
%
if nargout == 0
    error('function caller should receive obj.');
end
