function [obj] = brain_data_new(coord_type, model_name, conductivity)
% create brain_data object
% [USAGE]
%    [obj] = brain_data_new(<coord_type>, <model_name>);
% [IN]
%    coord_type : coordinate type of brain_data
%    model_name : model name of brain_data
% [OUT]
%    obj : brain_data object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

const = define_bm_edit_app;

%
% --- Previous check
%
if ~exist('coord_type', 'var')
    error('coord_type is a required parameter.');
end
if ~exist('model_name', 'var') || isempty(model_name)
    error('model_name is a required parameter.');
end
if ~exist('conductivity', 'var') || isempty(conductivity)
    conductivity = const.DEFAULT_CONDUCTIVITY;
end

% set class type
obj.class_type = 'brain_data';

%
% --- Main Procedure
%
obj.coord_type   = coord_type;
obj.model_name   = model_name;
obj.conductivity = conductivity;
obj.history = history_new;

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
