function [obj] = bm_process_parm_create_parameter(parm_type)
% create bm_process_parm object
% [USAGE]
%    [obj] = bm_process_parm_create(<parm_type>);
% [IN]
%    parm_type : concreate parameter type
% [OUT]
%    obj : concrete parameter object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('parm_type', 'var')
    error('parm_type is a required parameter.');
end

%
% --- Main Procedure
%
const = define_bm_edit_app;

switch(parm_type)
    case const.parm_type.SURF_SMOOTH_PARM
        obj = surf_smooth_parm_new;
    case const.parm_type.SURF_SMOOTH_EXPAND_PARM
        obj = surf_smooth_expand_parm_new;
    case const.parm_type.SURF_TO_FILLED_MASK_PARM
        obj = surf_to_filled_mask_parm_new;
    case const.parm_type.SEPARATE_SURF_PARM
        obj = separate_surf_parm_new;
    case const.parm_type.COMBINE_SURF_PARM
        obj = combine_surf_parm_new;
    case const.parm_type.CLOSE_SURF_PARM
        obj = close_surf_parm_new;
    case const.parm_type.MORPHOLOGY_OPERATION_PARM
        obj = morphology_operation_parm_new;
    case const.parm_type.SURF_EXTRACT_PARM
        obj = surf_extract_parm_new;
end

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
