function [result] = bm_process_parm_check_parameter(obj)
% check parameter and return check result.
% [USAGE]
%    [result] = bm_process_parm_check_parameter(<obj>);
% [IN]
%    obj : bm_process_parm object
% [OUT]
%    result : check result
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a requird parameter.'); end

%
% --- Main Procedure
%
result = FAILURE;
switch(obj.class_type)
    % surf_data parameters
    case 'surf_smooth_parameter'
        result = surf_smooth_parm_check_parameter(obj);
    case 'surf_smooth_expand_parameter'
        result = surf_smooth_expand_parm_check_parameter(obj);
    case 'surf_to_filled_mask_parameter'
        result = surf_to_filled_mask_parm_check_parameter(obj);
    case 'separate_surf_parameter'
        result = separate_surf_parm_check_parameter(obj);
    case 'combine_surf_parameter'
        result = combine_surf_parm_check_parameter(obj);
    case 'close_surf_parameter'
        result = close_surf_parm_check_parameter(obj);
    case 'connected_vertex_parameter'
        result = connected_vertex_parm_check_parameter(obj);
    % mask_data parameters
    case 'morphology_operation_parameter'
        result = morphology_operation_parm_check_parameter(obj);
    case 'surf_extract_parameter'
        result = surf_extract_parm_check_parameter(obj);
end
