function [obj, result] = ...
        bm_manager_set_process_parameter(obj, parm_type, parm)
% set parameter to parameter list
% [USAGE]
%    [obj, result] = ...
%    bm_manager_set_process_parameter(<obj>, <parm_type>, <parm>);
% [IN]
%          obj : bm_manager object
%    parm_type : parameter type
%         parm : <<structure>> parameter
% [OUT]
%       obj : bm_manager object
%    result : set result(SUCCESS/FAILURE)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~strcmp(obj.class_type, 'bm_manager')
    error('class type is invalid.');
end
if ~exist('parm_type', 'var')
    error('parm_type is a required parameter.');
end
if ~exist('parm', 'var'), error('parm is a required parameter.'); end

%
% --- Main Procedure
%

% set parameter to parameter list
[obj.parm_list, result] = ...
    bm_process_parm_list_set_parameter(obj.parm_list, parm_type, parm);

%
% --- After check
%
if nargout ~= 2
    error('function caller should receive obj and result');
end
