function [description_cell, parm_cell] = ...
                        bm_manager_get_history(obj, index_no)
% get history of one brain.
% [USAGE]
%    [description_cell, parm_cell] = ...
%                        bm_manager_get_history(<obj>, <index_no>)
% [IN]
%         obj : bm_manager object
%    index_no : one brain model index number. (scalar)
% [OUT]
%    description_cell : processing description list
%           parm_cell : processing parameter list
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~strcmp(obj.class_type, 'bm_manager')
    error('class type is invalid.');
end
if ~exist('index_no', 'var')
    error('index_no is a required parameter.');
end

%
% --- Main Procedure
%
brain_model_cell = bm_list_get_brain_model(obj.bm_list, index_no);

[description_cell, parm_cell] = ...
        brain_data_get_history_item_all(brain_model_cell{1});

