function [obj] = bm_manager_change_conductivity(obj, index, new_conductivity)
% change conductivity value
% [USAGE]
%    [obj] = bm_manager_change_conductivity(<obj>, <new_conductivity>);
% [IN]
%                 obj : bm_manager object
%               index : bm_list index
%    new_conductivity : new conductivity value
% [OUT]
%    obj : bm_manager object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('index', 'var'), error('index is a required parameter.'); end
if ~exist('new_conductivity', 'var')
    error('new_conductivity is a required parameter.');
end

%
% --- Main Procedure
%
brain_data_cell = bm_list_get_brain_model(obj.bm_list, index);

for k=1:length(brain_data_cell)
    brain_data = brain_data_cell{k};
    old_conductivity = brain_data_get_conductivity(brain_data);

    % Change conductivity value
    brain_data = brain_data_set_conductivity(brain_data, new_conductivity);

    % write rename history
    history_str = ['conductivity was changed from ' ...
                    num2str(old_conductivity), ' to ' ...
                    num2str(new_conductivity)];
    brain_data  = brain_data_add_history_item(brain_data, history_str);
    % regist
    obj.bm_list = bm_list_overwrite_model(obj.bm_list, ...
                                             brain_data, ...
                                             index(k));
end
