function [brain_data_cell] = bm_list_get_brain_model(obj, index)
% get cell including brain_data object
% [USAGE]
%    [brain_data_cell] = bm_list_get_brain_model(<obj>, <index>);
% [IN]
%      obj : bm_list object
%    index : bm_list index(Nx1)
% [OUT]
%    brain_data_cell : cell including brain_data object.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('index', 'var'), error('index is a required parameter.'); end
if ~strcmp(obj.class_type, 'bm_list')
    error('class type is invalid.');
end

% index range check
original_index = bm_list_get_brain_model_index(obj);
for k=1:length(index)
    if isempty( find(original_index == index(k)) )
        %error('specified index is out of range.');
        brain_data_cell = cell(0);
        return;
    end
end

%
% --- Main Procedure
%
Nget = length(index);
brain_data_cell = cell(Nget, 1);
for k=1:Nget
    brain_data_cell{k} = obj.brain_data_list{index(k)};
end
