function [V_cell, F_cell, xx_cell, model_name_cell, conduct_cell] = ...
           bm_fileio_read_mask_file(mask_file, brain_part, analyze_info)
% Read mask file and get specfied part of brain.
% [IN]
%        mask_file : personal brain mask file(.mat)
%       brain_part : want to get part of brain. ('brain', 'cortex')
%     analyze_info : analyze file information
% [OUT]
%             V_cell : cell array of vertex
%             F_cell : cell array of face
%            xx_cell : cell array of normal vector
%    model_name_cell : cell array of model name
%       conduct_cell : cell array of conductivity
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('mask_file', 'var')
    error('mask_file is a required parameter.');
end
if ~exist('brain_part', 'var')
    error('brain_part is a required parameter.');
end
if ~exist('analyze_info', 'var')
    error('analyze_info is a required parameter.');
end

%
% --- Main Procedure
%
analyze_file = vb_analyze_info_get_file_prefix(analyze_info);
Vdim  = vb_analyze_info_get_voxdim(analyze_info);
Vsize = vb_analyze_info_get_voxsize(analyze_info);

Para.Nvertex = 3000; % ĺ
Para.vstep = 2  ;   % ᡼ܥ륵 [mm]
Para.Nloop = 200; 	% ޥեåȷ֤
Para.Nlast = 10; 	% Хͥǥʿ경֤
Para.Radius = [2 4 -4 -2];% morphological smoothing for brain

%
% --- Get subject brain mask (voxel size = step [mm])
%
const = define_bm_edit_app;

for k=1:length(brain_part)
    switch(brain_part{k})
        case const.str.MASK_FILE_IMPORT_CORTEX
            [avw, Xcenter] = vb_get_brain_mask(mask_file, ...
                                            'cortex', ...
                                            '', ...
                                            Para.vstep);
        case const.str.MASK_FILE_IMPORT_BRAIN
            [avw, Xcenter] = vb_get_brain_mask(mask_file, ...
                                            'brain', ...
                                            '', ...
                                            Para.vstep);
    end

    % make surface
    [V, F, xx] = vb_mask_to_surf_expand(avw.img, Para);
    V = vb_analyze_right_mm_to_spm_right(V, Vdim, Vsize);

    % make output data
    V_cell{k} = V;
    F_cell{k} = F;
    xx_cell{k} = xx;
    model_name_cell{k} = brain_part{k};
    conduct_cell{k} = const.DEFAULT_CONDUCTIVITY;
end
