function [obj, result] = bm_fileio_export_file(...
                                  obj, file_type, out_file, analyze_info)
% export brain model
% [USAGE]
%    [obj, result] = 
%       bm_fileio_export_file(<obj>, <file_type>, <out_file>, <analyze_info>);
% [IN]
%             obj : bm_fileio object
%       file_type : export file type
%        out_file : output filename(fullpath)
%    analyze_info : convert coord info (analyze_right_mm to Spm_Right_m)
% [OUT]
%       obj : bm_fileio object
%    result : export result(SUCCESS or FAILURE)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('file_type', 'var')
    error('file_type is a required parameter.');
end
if ~exist('out_file', 'var')
    error('out_file is a required parameter.');
end
if ~isfield(obj, 'bm_list') || isempty(obj.bm_list)
    error('bm_fileio has no data to export');
end

%
% --- Main Procedure
%
global vbmeg_inst;
result = SUCCESS;

app_const = define_bm_edit_app;

% Make output data
index = bm_list_get_brain_model_index(obj.bm_list);
Ndata = length(index);

% allocate memory
model_name_cell = cell(Ndata, 1);
V_cell       = cell(Ndata, 1);
F_cell       = cell(Ndata, 1);
xx_cell      = cell(Ndata, 1);
conduct_cell = cell(Ndata, 1);

% get data
brain_data_cell = bm_list_get_brain_model(obj.bm_list, index);

% split data
for k=1:length(brain_data_cell)
    % model name
    model_name_cell{k} = brain_data_get_model_name(brain_data_cell{k});
    % vertex
    %   -- convert from Analyze right mm -->SPM_right m 
    V_cell{k} = vb_analyze_right_mm_to_spm_right(...
                            surf_data_get_vertex(brain_data_cell{k}), ...
                            vb_analyze_info_get_voxdim(analyze_info), ...
                            vb_analyze_info_get_voxsize(analyze_info));
    % Face
    F_cell{k} = surf_data_get_face(brain_data_cell{k});
    % xx
    xx_cell{k} = surf_data_get_normal_vector(brain_data_cell{k});
    % conductivity
    conduct_cell{k} = brain_data_get_conductivity(brain_data_cell{k});
end
clear brain_data_cell;

Vinfo.Coord = 'SPM_Right_m';

% write data
switch(file_type)
    case app_const.file_type.HEAD_FILE
        result = bm_fileio_write_head_file(out_file, ...
                                        V_cell, F_cell, xx_cell,...
                                        model_name_cell, conduct_cell);
    otherwise
        error('specified file_type is invalid.');
end
