function [obj] = bm_edit_app_view3d_update(obj, brain_app, ...
                                           func_h, view_setting3d)
% 3d view update.
% [USAGE]
%    [obj] = bm_edit_app_view3d_update(<obj>,
%                                      <brain_app>, <func_h>,
%                                      <view_setting3d>);
% [IN]
%                obj : bm_edit_app_view3d object
%          brain_app : brain application object
%             func_h : bm_edit_app object
%    view_setting_3d : view_setting_3d object
% [OUT]
%    bm_edit_app_view3d object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('brain_app', 'var')
    error('brain_app is a required parameter.');
end
if ~exist('func_h', 'var'), error('func_h is a required parameter.'); end
if ~exist('view_setting3d', 'var')
    error('view_setting3d is a required parameter.');
end

%
% --- Main Procedure
%

% get display data
display_factor = feval(func_h, brain_app);

% update display(brain)
obj = bm_edit_app_view3d_display_brain(obj, display_factor, view_setting3d);

% update selected model window
H = guihandles(obj.h);
model_names = cell(0);
Nmodel = vb_display_factor_get_length(display_factor);
for k=1:Nmodel
    element = vb_display_factor_get_element(display_factor, k);
    model_names{k} = vb_display_element_get_name(element);
end
set(H.model_listbox, 'String', model_names);
set(H.model_listbox, 'Value', 1);
bm_edit_app_view3d_callback(obj, H.model_listbox);

% Save object to figure
guidata(obj.h, obj);

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
