function [obj] = bm_edit_app_view3d_display_brain(...
                                     obj, display_factor, view_setting3d)
% display 3D brain.
% [USAGE]
%    obj = bm_edit_app_view3d_display_brain(...
%                             <obj>, <display_factor>, <view_setting3d>);
% [IN]
%               obj : bm_edit_app_view3d object
%    display_factor : to be plotted brain model
%    view_setting3d : property for plot
% [OUT]
%    obj : bm_edit_app_view3d object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('display_factor', 'var')
    error('display_factor is a required parameter.');
end
if ~exist('view_setting3d', 'var')
    error('view_setting3d is a required parameter.');
end

%
% --- Main Procedure
%
if ~ishandle(obj.h)
    obj = bm_edit_app_view3d_make_figure(obj, view_setting3d);
end

% Color Setting
fclr = zeros(5, 3);
face_color = cell(0);
face_color{1} = [0.8 0.7 0.6];
eclr  = 'none';
light_mode = 0;
max_mode   = 1;

% GUI initialize
H = guihandles(obj.h);
figure(obj.h);
cla(H.model_axes);
obj.patch_handles = [];

% Display models
Nelements = vb_display_factor_get_length(display_factor);
model_names = cell(0);
for k=1:Nelements
    element = vb_display_factor_get_element(display_factor, k);
    switch(element.class_name)
        case 'surf_element'
            vertex = vb_surf_element_get_vertex(element);
            face   = vb_surf_element_get_face(element);
            name   = vb_display_element_get_name(element);
            if strcmpi(name, 'csf')
                f_color = [11 132 199]/255;
                alpha   = 1.0;
            elseif strcmpi(name, 'skull')
                f_color = [128 128 128]/255;
                alpha   = 0.5;
            elseif strcmpi(name, 'scalp')
                f_color = [0.8 0.7 0.6];
                alpha   = 0.4;
            else
                f_color = face_color{1};
                alpha   = 1.0;
            end
            patch_h = bm_edit_app_view3d_plot_surf(...
                            obj, ...
                            H.model_axes, ...
                            vertex, ...
                            face, ...
                            f_color, ...
                            alpha, ...
                            max_mode);
            obj.patch_handles = [obj.patch_handles; patch_h];
            model_names{length(model_names)+1} = vb_display_element_get_name(element);
    end
end

% Light
camlight(-60,0);
camlight(60,0);
camlight(180,0);

% Set model name
set(H.model_listbox, 'String', model_names);

xlim('auto');
ylim('auto');
zlim('auto');

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
