function [obj] = bm_edit_app_update_ui_state(obj)
% update application ui status
% [USAGE]
%    [obj] = bm_edit_app_update_ui_state(<obj>);
% [IN]
%    obj : bm_edit_app object
% [OUT]
%    obj : bm_edit_app object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~strcmp(obj.class_type, 'bm_edit_app')
    error('class type is invalid.');
end

%
% --- Main Procedure
%
H = guihandles(obj.h);

% Material for change ui
all_index = bm_manager_get_bm_list_index(obj.bmm);
selected_index = get(H.brain_model_list_listbox, 'value');
Nselected = length(selected_index);
selected_type_is_all_same = false;
selected_model_info = cell(0);
model_type = [];

if ~isempty(all_index) && Nselected >= 1
    selected_model_info = bm_manager_get_model_info(obj.bmm, selected_index);
    if Nselected >= 1
       model_type = selected_model_info{1}.class_type;
    end
    % selected model type check
    for k=1:Nselected
        if strcmp(selected_model_info{k}.class_type, model_type)
            selected_type_is_all_same = true;
        else
            selected_type_is_all_same = false;
            break;
        end
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%
% Import file push status
%%%%%%%%%%%%%%%%%%%%%%%%%%
Import_button_group = [H.brain_file_push;
                       H.head_file_push;
                       H.curry_file_push;
                       H.face_file_push;
                       H.mask_file_push;
                       H.spm_norm_file_push];
if length(get(H.analyze_file_edit, 'String')) == 0
    set(Import_button_group, 'Enable', 'off');
else
    set(Import_button_group, 'Enable', 'on');
end


%%%%%%%%%%%%%%%%%%%%%%%%%
% 2D / 3D button status
%%%%%%%%%%%%%%%%%%%%%%%%%
% brain model is NOT loaded.
set(H.view2d_push, 'Enable', 'off');
set(H.view3d_push, 'Enable', 'off');

if ~isempty(all_index)
    % 2D is always on
    set(H.view2d_push, 'Enable', 'on');
    % change 3d button state
    if selected_type_is_all_same && strcmp(model_type, 'mask_image_data')
        % Disable 3D menu
        set(H.view3d_push, 'Enable', 'off');
    else
        set(H.view3d_push, 'Enable', 'on');
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%
% Processing menu status
%%%%%%%%%%%%%%%%%%%%%%%%%%
% Disable menus
set(H.processing_surf_data_menu, 'Enable', 'off');
set(H.processing_mask_data_menu, 'Enable', 'off');

if ~isempty(all_index)
    if selected_type_is_all_same && strcmp(model_type, 'surf_data')
        % Enable surf_data menu
        set(H.processing_surf_data_menu, 'Enable', 'on');
    elseif selected_type_is_all_same && strcmp(model_type, 'mask_image_data')
        % Enable mask_data menu
        set(H.processing_mask_data_menu, 'Enable', 'on');
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Processing button status
%%%%%%%%%%%%%%%%%%%%%%%%%%%%
surf_group = [H.surf_smooth_push;
              H.surf_smooth_expand_push;
              H.surf_to_filled_mask_push;
              H.separate_surf_push;
              H.close_surf_push];
mask_group = [H.morphology_operation_push;
              H.surf_extract_push];
set(surf_group, 'Enable', 'off');
set(mask_group, 'Enable', 'off');

if ~isempty(all_index)
    if selected_type_is_all_same && strcmp(model_type, 'surf_data')
        set(surf_group, 'Enable', 'on');
        % vb_surf_to_filled_mask, vb_surf_smooth_expand 
        % cannot be applied to unclosed surface.
        for k=1:length(selected_model_info)
            if(selected_model_info{k}.surf_close) == false
                set(H.surf_to_filled_mask_push, 'Enable', 'off');
                set(H.surf_smooth_expand_push, 'Enable', 'off');
                set(H.close_surf_push, 'Enable', 'on');
            else
                set(H.close_surf_push, 'Enable', 'off');
            end
        end
    elseif selected_type_is_all_same && strcmp(model_type, 'mask_image_data')
        set(mask_group, 'Enable', 'on');
    end
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% rename/delete button status
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if isempty(all_index)
    set(H.rename_push, 'Enable', 'off');
    set(H.delete_push, 'Enable', 'off');
else
    set(H.rename_push, 'Enable', 'on');
    set(H.delete_push, 'Enable', 'on');
end    

%%%%%%%%%%%%%%%%%%%%%%
% Export menu status
%%%%%%%%%%%%%%%%%%%%%%
if selected_type_is_all_same && strcmp(model_type, 'surf_data')
    set(H.export_push, 'Enable', 'on');
else
    set(H.export_push, 'Enable', 'off');
end

% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
