function [obj] = bm_edit_app_new()
% create bm_edit_app object
% [USAGE]
%    [obj] = bm_edit_app_new;
% [IN]
%    none
% [OUT]
%    obj : bm_edit_app object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

obj = struct;

% set class type
obj.class_type = 'bm_edit_app';

%
% --- Member initialize
%

% brain model name list
obj.model_name_list = cell(0);

% view object
obj.view2d = bm_edit_app_view2d_new;
obj.view3d = bm_edit_app_view3d_new;

% view setting object
obj.view_setting2d = bm_view_parm2d_new;
obj.view_setting3d = bm_view_parm3d_new;

% brain model manager
obj.bmm = bm_manager_new;

% process parm editor
obj.ppm = process_parm_editor_new;

% Figure handle
obj.h = openfig('bm_edit_app.fig');

% menu map for menu to parm_type conversion
obj.menu_parm_map = bm_edit_app_make_menu_map(obj);

% ui status update
obj = bm_edit_app_update_ui_state(obj);

%
% --- save application instance to figure
%
guidata(obj.h, obj);

