function [display_factor] = bm_edit_app_get_display_factor(obj)
% get display factor for view(2d, 3d).
% [USAGE]
%    [display_factor] = bm_edit_app_get_display_factor(<brain_app>)
% [IN]
%    obj : bm_edit_app object
% [OUT]
%    display_factor : display factor for view(2d, 3d).
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~strcmp(obj.class_type, 'bm_edit_app')
    error('class type is invalid.');
end

%
% --- Main Procedure
%

H = guihandles(obj.h);

% get selected model data
index = get(H.brain_model_list_listbox, 'value');
display_factor = bm_manager_get_display_factor(obj.bmm, index);
