function bayes_parm_editor_init_advanced_gui(obj)
% creates bayes advanced parameter gui.
% [USAGE]
%    adv_fig = bayes_parm_editor_init_advanced_gui(<obj>);
% [IN]
%    obj : bayes_parm_editor object (@see bayes_parm_editor_init())
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var') || isempty(obj) || ~ishandle(obj)
    error('invalid obj is specified.');
end

%
% --- Main Procedure
%

% load data(@see bayes_parm_editor_init())
data = guidata(obj);
basic_gui_data = guidata(data.basic_fig);
basic_gui_handles = basic_gui_data.H;

if ishandle(data.adv_fig)
    figure(data.adv_fig);
else
    data.adv_fig = bayes_parm_advanced_init(obj, data.bayes_parm);
end

% save data
guidata(obj, data);
