function vb_batch_job_mkdir(dummy, mkdir_parm)
% Make directories.
% [USAGE]
%    vb_batch_job_mkdir(dummy, mkdir_parm);
% [IN]
%         dummy : dummy field. This fields exists for
%                 compatibility for other job functions.
%    mkdir_parm : 
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('dummy', 'var')
    error('dummy is a required parameter.');
end
if ~exist('mkdir_parm', 'var')
    error('mkdir_parm is a required parameter.');
end
if ~isfield(mkdir_parm, 'directories')
    error('mkdir_parm should have a field named directories');
end

%
% --- Main Procedure
%
directories  = mkdir_parm.directories;
Ndirectories = length(directories);
const = vb_define_verbose;

for k=1:Ndirectories
    directory = directories{k};
    if ~isempty(directory)
        err_code = 1; %1=SUCCESS
        err_msg  = '';
        try
            err_code = vb_mkdir(directory);
        catch
            err_code = 0;
            err = lasterror;
            err_msg = err.message;
        end
            
        if err_code == 0
            % FAILURE
            vb_disp(...
             sprintf('''%s'' was NOT created.', directory), ...
             const.VERBOSE_LEVEL_WARNING);
        else
            vb_disp(...
             sprintf('''%s'' was created.', directory), ...
             const.VERBOSE_LEVEL_NOTICE);
        end
    end
end

