function [obj, errmsg] = ...
             vb_batch_variable_table_change_column_name(obj, old_name, new_name)
% Rename variable name
% [USAGE]
%    [obj, errmsg] = ...
%      vb_batch_variable_table_change_column_name(<obj>,<old_name>,<new_name>);
% [IN]
%         obj : vb_batch_variable_table object
%    old_name : name before changing [STRING]
%    new_name : name after changing  [STRING]
% [OUT]
%         obj : vb_batch_variable_table object
%      errmsg : error msg(when error occurs, reason is put here.)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a requierd parameter.');
end
if ~exist('old_name', 'var')
    error('old_name is a required parameter.');
end
if ~exist('new_name', 'var')
    error('new_name is a required parameter.');
end

%
% --- Main Procedure
%
errmsg = '';

% Duplication check
ix_dup = strmatch(new_name, obj.column_name_list, 'exact');
if ~isempty(ix_dup)
    errmsg = 'Specified variable name already exists.';
    return;
end
ix = strmatch(old_name, obj.column_name_list, 'exact');
if isempty(ix)
    errmsg = 'The variable name before changing was not found.';
    return;
else
    obj.column_name_list{ix} = new_name;
end

%
% --- After check
%
if nargout < 1
    error('function caller should receive this object.');
end
