function [obj] = vb_batch_mgr_swap_parm(obj, ix_main, ix_sub1, ix_sub2)
% Swap parameters in the specified parameter set.
% [USAGE]
%    [obj] = vb_batch_mgr_swap_parm(<obj>, <ix_main>, <ix_sub1>, <ix_sub2>);
% [IN]
%         obj : vb_batch_mgr object.
%     ix_main : parameter set specifier
%                = 0 : template parameter set
%                >=1 : batch parameter set
%     ix_sub1 : parameter id
%     ix_sub2 : parameter id
% [OUT]
%    obj : vb_batch_mgr object.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end
if ~exist('ix_main', 'var')
    error('ix_main is a required parameter.');
end
if ~exist('ix_sub1', 'var')
    error('ix_sub1 is a required parameter.');
end
if ~exist('ix_sub2', 'var')
    error('ix_sub2 is a required parameter.');
end

%
% --- Main Procedure
%

% get object
parm_set = vb_batch_mgr_get_parm_set(obj, ix_main);

% swap parameter
parm_set = vb_batch_parm_set_swap(parm_set, ix_sub1, ix_sub2);

% set parameter set to the vb_batch_mgr object
obj = vb_batch_mgr_set_parm_set(obj, ix_main, parm_set);

%
% --- After check
%
if nargout < 1
    error('function caller should receive vb_batch_mgr object.');
end
