function [obj, errmsg] = ...
                   vb_batch_mgr_set_parm(obj, ix_main, ix_sub, parm, parm_type)
% Set parameter to the specified parameter set
%
% [USAGE]
%    [obj, errmsg] = 
%        vb_batch_mgr_set_parm(<obj>, <ix_main>, <ix_sub>, <parm>, <parm_type>);
% [IN]
%          obj : vb_batch_mgr object
%      ix_main : parameter set specifier
%                = 0 : template parameter set
%                >=1 : batch parameter set
%       ix_sub : index in the parameter set.
%         parm : to be added parameter to the set
%    parm_type : parameter type such as 'brain_parm', 'head_parm',.. [STRING]
% [OUT]
%       obj : vb_batch_mgr object
%    errmsg : if error occured, the reason will be containd.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end
if ~exist('ix_main', 'var')
    error('ix_main is a required parameter.');
end
if ~exist('ix_sub', 'var')
    error('ix_sub is a required parameter.');
end
if ~exist('parm', 'var')
    error('parm is a required parameter.');
end
if ~exist('parm_type', 'var')
    error('parm_type is a required parameter.');
end

%
% --- Main Procedure
%

% get specified parameter set
parm_set = vb_batch_mgr_get_parm_set(obj, ix_main);

% set parameter
[parm_set, errmsg] = vb_batch_parm_set_set_parm(parm_set, ...
                                                ix_sub, ...
                                                parm, parm_type);

% save modified parameter set to vb_batch_mgr
[obj] = vb_batch_mgr_set_parm_set(obj, ix_main, parm_set);

%
% --- After check
%
if nargout < 1
    error('function caller should receive this object.');
end
