function [obj] = vb_batch_mgr_remove_varable(obj, variable_name)
% Remove variable from the table
%
% [USAGE]
%    [obj] = vb_batch_mgr_remove_varable(<obj, <variable_name>);
% [IN]
%              obj : vb_batch_mgr object
%    variable_name : variable name such as '$ID$', '$SUBJ$' [STRING]
% [OUT]
%       obj : vb_batch_mgr object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end
if ~exist('variable_name', 'var')
    error('obj is a required parameter.');
end
if ~ischar(variable_name) || isempty(variable_name)
    error('variable name is invalid');
end

%
% --- Main Procedure
%

% Add variable
[obj.table] = ...
    vb_batch_variable_table_remove_column(obj.table, variable_name);

%
% --- After check
%
if nargout < 1
    error('function caller should receive obj.');
end
