function [obj] = vb_batch_mgr_remove_parm(obj, ix_main, ix_sub)
% Remove parameter
%
% [USAGE]
%    [obj] = vb_batch_mgr_remove_parm(<obj>, <ix_main>, <ix_sub>);
% [IN]
%        obj : vb_batch_mgr object
%    ix_main : parameter set specifier
%              = 0 : template parameter set
%              >=1 : batch parameter set
%     ix_sub : index in the parameter set.
% [OUT]
%       obj : vb_batch_mgr object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end
if ~exist('ix_main', 'var')
    error('ix_main is a required parameter.');
end
if ~exist('ix_sub', 'var')
    error('ix_sub is a required parameter.');
end

%
% --- Main Procedure
%

% get specified parameter set
parm_set = vb_batch_mgr_get_parm_set(obj, ix_main);

% remove specified parameter in parameter set.
parm_set = vb_batch_parm_set_remove_parm(parm_set, ix_sub);

% set updated parameter set to the vb_batch_mgr object
obj = vb_batch_mgr_set_parm_set(obj, ix_main, parm_set);


%
% --- After check
%
if nargout < 1
    error('function caller should receive vb_batch_mgr object.');
end
