function obj = vb_batch_mgr_new(name)
% This function creates vb_batch_mgr object
%
% [USAGE]
%    [obj] = vb_batch_mgr_new(<name>);
% [IN]
%    name : builder name
% [OUT]
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


%
% --- Previous check
%
if ~exist('name', 'var')
    error('name is a required parameter.');
end

%
% --- Main Procedure
%
obj = struct;
obj.name     = name;
obj.template = vb_batch_parm_set_new('template');
obj.parm_set = cell(0);
obj.table    = vb_batch_variable_table_new;

% batch output index list
% = 0 : template parameter set
% >=1 : parm_set index
obj.ix_output= [];

%
% --- After check
%
if nargout < 1
    error('function caller should receive obj.');
end
