function [parm, parm_type, parm_set_name] = ...
                                 vb_batch_mgr_get_parm(obj, ix_main, ix_sub)
% Get parameter from specified parameter set.
% [USAGE]
%    [parm, parm_type, parm_set_name] = ...
%                                vb_batch_mgr_get_parm(<obj>, <ix_main>, <ix_sub>);
% [IN]
%        obj : vb_batch_mgr object.
%    ix_main : parameter set specifier
%               = 0 : template parameter set
%               >=1 : batch parameter set
%     ix_sub : Nth parameter in the parameter set.
% [OUT]
%             parm : parameter
%        parm_type : parameter type
%                     such as 'brain_parm', 'head_parm',.. [STRING]
%    parm_set_name : The name of parameter set.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end
if ~exist('ix_main', 'var')
    error('ix_main is a required parameter.');
end
if ~exist('ix_sub', 'var')
    error('ix_sub is a required parameter.');
end

%
% --- Main Procedure
%

% get specified parameter set
parm_set = vb_batch_mgr_get_parm_set(obj, ix_main);

% get parameter
[parm, parm_type] = vb_batch_parm_set_get_parm(parm_set, ix_sub);

% get the name of parameter set
parm_set_name = vb_batch_parm_set_get_name(parm_set);
