function [id_str] = vb_batch_mgr_get_output_id_string(obj)
% get id list for output
% [USAGE]
%    [id_str] = vb_batch_mgr_get_output_id_string(<obj>);
% [IN]
%    obj : vb_batch_mgr object
% [OUT]
%    id_str : id string list selected by user
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end

%
% --- Main Procedure
%
id_str = cell(0);

ix_main_list = vb_batch_mgr_get_output_index_list(obj);

for k=1:length(ix_main_list)
    % get parameter set
    parm_set = vb_batch_mgr_get_parm_set(obj, ix_main_list(k));

    % get ID of parameter set
    id_str{k, 1} = vb_batch_parm_set_get_name(parm_set);
end
