function [N] = vb_batch_mgr_get_num_of_parm(obj, ix_main)
% return the number of parameters which parameter set has.
%
% [USAGE]
%    [N] = vb_batch_mgr_get_num_of_parm(<obj>,<ix_main>)
% [IN]
%        obj : vb_batch_mgr object
%    ix_main : = 0 : check template parameter set.
%    ix_main   >=1 : check specified parameter set.
%                    (to get the number of parameter set,
%                     use vb_batch_mgr_get_num_of_parm_set(); )
% [OUT]
%    the number of parameters which parameter set has.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end
if ~exist('ix_main', 'var')
    error('ix_main is a required parameter.');
end

%
% --- Main Procedure
%
N = 0;
[parm_set] = vb_batch_mgr_get_parm_set(obj, ix_main);

% Return the number of parameters in the specified parameter set.
if ~isempty(parm_set)
    N = vb_batch_parm_set_get_num_of_parm(parm_set);
end
