function [obj] = vb_batch_mgr_edit_table(obj)
% Edit variable table
%
% [USAGE]
%    [obj] = vb_batch_mgr_edit_table(<obj>);
% [IN]
%    obj : vb_batch_mgr object
% [OUT]
%    obj : vb_batch_mgr object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end

%
% --- Main Procedure
%

% get table data
[column_name_list, data] = vb_batch_variable_table_get_data(obj.table);

% launch editor
h = figure;
set(h, 'Menubar', 'none', 'Name', 'Edit table', 'NumberTitle', 'off');
mtable = createTable([], column_name_list, data);
set(h, 'closereq', 'set(gcf, ''visible'', ''off'')');

% wait for close editor
waitfor(h, 'visible', 'off');

% get data from editor
data = cell(mtable.getData);

% deblank is applied.
[M, N] = size(data);
for k=1:M
    for j=1:N
        if ischar(data{k, j})
            data{k, j} = deblank(data{k, j});
        end
    end
end

if ishandle(h), delete(h); end

% set data to table
[obj.table] = ...
   vb_batch_variable_table_set_data(obj.table, column_name_list, data);


%
% --- After check
%
if nargout < 1
    error('function caller should receive obj.');
end
