function vb_batch_list_update_template_parm_listbox(fig)
% update template parameter listbox
%
% [USAGE]
%    vb_batch_list_update_template_parm_listbox(<fig>);
% [IN]
%    fig : figure handle
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle is specified.');
end

%
% --- Main Procedure
%
data = guidata(fig);

% get the number of parameters in the selected parameter set.
ix_main = 0;
Nparm = vb_batch_mgr_get_num_of_parm(data.bmgr, ix_main);

% set parameter type to listbox
listbox_str = cell(0);
for k=1:Nparm
    ix_sub = k;
    [parm, parm_type] = vb_batch_mgr_get_parm(data.bmgr, ix_main, ix_sub);
    parm_str = parm_type;
    if isfield(parm, 'time_stamp')
        parm_str = [parm.time_stamp, ' ', parm_type];
    end
    listbox_str{k, 1} = parm_str;
end
set(data.H.template_parameter_listbox, 'String', listbox_str);

% Adjust selected line number
line_no = get(data.H.template_parameter_listbox, 'Value');
if Nparm < 1
    line_no = 1;
elseif line_no > Nparm
    line_no = Nparm;
end
set(data.H.template_parameter_listbox, 'Value', line_no);

% Change state of Buttons
components = [data.H.upper_push; data.H.lower_push;
              data.H.remove_push; data.H.copy_push;
              data.H.edit_push;
              data.H.create_concrete_parm_push];
              
if Nparm
    set(components, 'Enable', 'on');
else
    set(components, 'Enable', 'off');
end
