function	B = vb_dipole_field_magdipole(x0,J0,X,Q)
% Lead field matrix for magnetic dipole 
%       (Note: it is different from current dipole)
%   B = vb_dipole_field_magdipole(x0,J0,X,Q)
%
% INPUT
%   -Dipole current source
%   x0 : current dipole position   ( NP x 3 )
%   J0 : current dipole moment     ( NP x 3 )
%   -MEG sensor
%   X : sensor position            ( NS x 3 )
%   Q : sensor orientation         ( NS x 3 )
% OUTPUT
%   B : Lead field matrix          ( NP x NS )
%
%   NP : # of dipole points
%   NS : # of MEG sensor
%
% Magnetic field produced by magnetic dipole
% Coil current can be approximated by magnetic dipole.
%
% ж˻Ҽ (ήήζ)
% x0 μж˻ J0  ¬ X ˺뼧 Q ͱ
%
% B = 3(Q*Xd)(J0*Xd)/|Xd|^5 - (Q*J0)/|Xd|^3 , Xd = X - x0
%
%  Ver-1.0 2007-7-9 Made by M. Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

NP = size(x0,1);
NS = size(X,1);

if NP >= NS
	B  = zeros(NP,NS);
	for n=1:NS
		Xn = X(n,:);
		Qn = Q(n,:);
		Xd = vb_repadd( -x0, Xn);	% [NP x 1]
		RR = sum( Xd.^2, 2 );

		B(:,n) = (3*(Xd*Qn').*sum(J0.*Xd,2)./RR - (J0*Qn'))./(RR.^(3/2));
	end;
else
	B  = zeros(NS,NP);
	for m=1:NP
		Jm = J0(m,:);
		xm = x0(m,:);
		Xd = vb_repadd( X, -xm);	% [NS x 1]
		RR = sum( Xd.^2, 2 );

		B(:,m) = (3*sum(Xd.*Q,2).*(Xd*Jm')./RR - (Q*Jm'))./(RR.^(3/2));
	end;
	B = B';
end;

B  = (10^-7) * B;
