function [Vindx, J ,emin] = vb_dipole_estimate_cov(bexp, basis, L, Cov)
% ---
% function [Vindx, J ,emin] = vb_dipole_estimate(bexp, basis, L, Cov)
% ñݡ
%
% Vindx : ꤵ줿ݡΥǥå
%       : ݡΰֺɸ = V(Vindx,:) 
% J     : ݡή
% emin  : 
%
% bexp  : MEG-data (Nsensor ,Time) 
% basis : Lead Field (Ndipole, Nsensor) 
% L = 2 (ή)
% Cov  : Noise covariance matrix  : Cov(sensor,sensor)
% ---
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin<3,
  L = 2;
end;

basis	= basis';		% basis(Nsensor, Ndipole)

[N , M] = size(basis);
Npoint	= M/L;

if nargin<4,
  SS	   = eye(N,N);
else
  SS	   = pinv(Cov);		% Inverce of Noise covariance matrix
end;

err 	= zeros(Npoint,1);
JJ		= zeros(Npoint,L);

id		= 0:(L-1);
id		= Npoint*id; % [ 0 , Npoint] for L=2

Bnorm   = sum(sum(bexp.^2));

for n = 1:Npoint,
  % Lead Field for the n-th dipole
  G  = basis(: , n + id);
	
  % Min. ( bexp - G*J )^2
  GG = inv( G' * SS * G ); % (L x L) matrix inverse
	
  % Diploe current
  J    = GG * (G' * SS * bexp);
  berr = bexp - G * J;
	
  % Reconstruction error
  err(n)  = sum( berr' * SS * berr )/Bnorm;
  JJ(n,:) = sqrt(sum( J.^2, 1));
end;

[ emin, Vindx ] = min( err );
J = JJ(Vindx,:);
