function	err = vb_dipole_error_sarvas(V, BB, pick, Qpick, Wsensor)
% error for dipole estimation (Sarvas)
%  err = vb_dipole_error_sarvas(V, BB, pick, Qpick, Wsensor)
% --- Output
% err  : Reconstruction error
%
% --- INPUT
%  V      : dipole position (Ndipole x 3)
%  V(n,:) : dipole position (3-D coordinate) at n-th vertex
%
% MEG covariance matrix
% BB    = bexp*bexp';	% BB(Nsensor,Nsensor)
% bexp   : MEG-data   (Nsensor ,Time) 
%
%  pick(k, 1:3) : Sensor coil position  : , 
% Qpick(k, 1:3)	: Sensor coil direction : 
%
% Wsensor : (sensor channel) x (sensor coil) : (Nsensor x Npick)
%
% basis(channel,dipole) = Wsensor * basis(coil,dipole)
%
% 2006-12-16 made by M.Sato
% 2007-4-3 made by M.Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

NV	  = length(V(:))/3;		% Number of dipoles
V     = reshape(V,[NV 3]);
Npick = size(pick,1);		% Number of sensor coil

%% Transform into spherical coordinate
[phi,theta,r] = cart2sph(V(:,1),V(:,2),V(:,3));

% Calculate unit dipole direction vector
[x1,y1,z1]	  = sph2cart(phi+0.5*pi, zeros(NV,1),  1); 
[x2,y2,z2]	  = sph2cart(  phi,      theta+0.5*pi, 1); 

vec1 = [x1,y1,z1];
vec2 = [x2,y2,z2];
%vec3 = V./repmat(sqrt(sum(V.^2, 2)), [NV 3]);

% calculate gradient of magnetic field by Sarvas equation
% G : Lead Field (Ndipole, Nsensor)
% L = 2 (ή)
L  = 2;
G  = zeros(NV*L , Npick);

for i=1:NV
	G(i,:)    = vb_sarvas_sensor(V(i,:),vec1(i,:),pick, Qpick)';
	G(i+NV,:) = vb_sarvas_sensor(V(i,:),vec2(i,:),pick, Qpick)';
end

G = G * Wsensor';

GGinv = pinv( G*G' ); % (NV*L x NV*L) matrix inverse

% Reconstruction error
% Error = ( B - G'*J )^2 = B^2  - ( B'* G'* GGinv * G * B )
Bnorm = sum(diag(BB));
err   = 1 - sum(sum(G.*(GGinv*G*BB)))/Bnorm;

