clear all

udir = 'D:\MatData\Connection\Test\';
%fn = 'input_Nvact10.mat';
fn = 'input.mat';

load([udir fn])

Nvact = 500;
Nloop = 1;
profile_on = 1;

% Reduce dimension for debug
Delta = Delta(1:Nvact, 1:Nvact);

profile_start(profile_on);

[Delta_set, Ndelta, indx, deltax, Nindx, nl_indx, NL_indx] = ...
	init_index(Delta);

init_matrix;
				
[AdtQA_V0] = init_AdtQA_V(Nvact, Ndelta, NL_indx);

[sp_dl_indx] = get_AdtQA_V_index(Nvact, Ndelta, NL_indx, AdtQA_V0);

if profile_on==0
	profile_end(profile_on);
	profile_start(profile_on);
end

for n=1:Nloop
	[AdtQA_V1] = cal_AdtQA_V ...
 	 (Nvact, Ndelta, Delta_set, ax_z, mar, Vmar, indx, deltax);
end

if profile_on==0
	profile_end(profile_on);
	profile_start(profile_on);
end

for n=1:Nloop
%	[AdtQA_V2] = set_AdtQA_V2(Nvact, Ndelta, ax_z, mar, Vmar, nl_indx, NL_indx);
	
	[AdtQA_V2] = set_AdtQA_V(Nvact, Ndelta, ax_z, mar, Vmar, ...
		nl_indx, NL_indx, sp_dl_indx, AdtQA_V0);
end

profile_end(profile_on);

[err2 ] = vb_err_cell(AdtQA_V1, AdtQA_V2)
%[err4 ] = vb_err_cell(AdtQA_V1, AdtQA_V4)
return
