function	V0 = vb_reduce_vivid(Coord, Nvivid)
% Reduce vertex points in vivid data
% V0 = vb_reduce_vivid(Coord,Nvivid)
% 
% --- Output
% V0     : Reduced vertex
% --- Input
% Nvivid : Reduced number of points in vivid data
% Coord  : Vivid vertex coordinate
% Coord : Left / Right /Front    head coordinate
%  'reduce_VRML'-File
%        .LV   / .RV   / .FV   : 3D-Coordinate   : [Npoint 3]  [mm]
%        .LF   / .RF   / .FF   : Patch index     : [Npatch Nnode]
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Reduce vertex points in vivid data
[FL, VL] = reducepatch(Coord.LF, Coord.LV, Nvivid);
[FR, VR] = reducepatch(Coord.RF, Coord.RV, Nvivid);

V0 = [VL; VR];

if isfield(Coord,'FF')
    [FF, VF] = vb_reducepatch(Coord.FF, Coord.FV, Nvivid);
    V0 = [V0; VF];
end
