function	[img1,img2,img3] = vb_read_vrml_image(fname)
% Read 2D Image from vrml-file
%
%   img1(Nx, Ny) : R color image 
%   img2(Nx, Ny) : G color image 
%   img3(Nx, Ny) : B color image 
%
% 		Texture2 {
% 		           image 400 400 3
%  0x000603 0x010603 0x030703 0x060704 0x060503 0x080703 0x070502 0x070502
%  0x090504 0x090404 0x090305 0x090307 0x080307 0x070206 0x090307 0x0b0408
% 		}
% 
% imageǡ¤ :[ Nx  Ny ]
% jx ; X-index  鱦 (from Left to Right)
% jy : Y-index (from Down to Up)
% 
% for jy=1:Ny
% 	for jx=1:Nx
% 		image(jx,jy)
% 	end
% end
% 
% 1ĤΥǡ '0x0b0307' 1ԥRGB(3Ĥ16ʿ)ɽ
% RGB = [0b0307]
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

key.start  = 'Texture2';
key.start2 = 'image';
key.end    = '}';
key.braket = '{';

[Nskip, Nline, Mmax] = vb_read_vrml_line(fname,key);

fid=fopen(fname);

% Skip lines until data
for n=1:Nskip
    next_line = fgetl(fid);
end

ix   = strfind(next_line,'image'); 

if isempty(ix),
% No image data
	img1=[];img2=[];img3=[];
	return;
end;

dim  = next_line( (ix+5):end );
Ndim = sscanf(dim,'%d %d %d');

Nx    = Ndim(1);
Ny    = Ndim(2);
Nbyte = Ndim(3);

fprintf('NX = %d , NY = %d\n', Nx,Ny);

% Start read data
img = zeros(Nx*Ny,Nbyte);
n2   = 0;

% Read data
for n=1:Nline
    next_line = fgetl(fid);
    
    % one line consists of 8 strings
    % each string '0x0b0307' represents three 2-char Hex integer
    % '0x0b0307' -> '0b' ,'03' ,'07'

	str = strrep(next_line,'0x','');	% eliminate '0x'
	x   = sscanf( str,'%2x');			% read 2-char Hex integer 
	M   = length(x)/Nbyte;

    n1  = n2 + 1;
    n2  = n2 + M;
	img(n1:n2,:) = reshape(x,[Nbyte M])';

end

fclose(fid);

if n2 ~= (Nx*Ny),
	error('Read format error');
end

% Reshape 2D-matrix and Scale value
img1  = reshape(img(:,1), [Nx Ny])/256;
img2  = reshape(img(:,2), [Nx Ny])/256;
img3  = reshape(img(:,3), [Nx Ny])/256;

