function    [Coord] = vb_read_vivid(fname,mode)
% Read VIVID VRML-Image
% --- Input
% fname.Left     = [dir subj '_left_reduce_VRML1.wrl' ];
% fname.Right    = [dir subj '_right_reduce_VRML1.wrl'];
% fname.Front    = [dir subj '_front_reduce_VRML1.wrl'];
%
% coord_mode = 0 ɸѴ̵
% coord_mode = 1; VIVID -> SPM-R
%  Vivid original format
%   X: ->
%   Y: ->
%   Z: ->
%  SPM-R
%   X: ->
%   Y: ->
%   Z: ->
% --- Output
% Coord : Left / Right /Front    head coordinate
%  'reduce_VRML'-File
%        .LV   / .RV   / .FV   : 3D-Coordinate   : [Npoint 3]  [m]
%        .LX   / .RX   / .FX   : 2D X-Coordinate : [Npoint 1]  [pixcel]
%        .LY   / .RY   / .FY   : 2D Y-Coordinate : [Npoint 1]  [pixcel]
%        .LF   / .RF   / .FF   : Patch index     : [Npatch Nnode]
%        .Limg / .Rimg / .Fimg : 2D RGB image    : [NX NY 3]
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% 2006/2/2  M. Sato 

if ~exist('mode','var'), mode = 1; end;

Coord = struct;

if isfield(fname ,'Left')
	[V, F, img, X, Y] = vb_read_vivid_file(fname.Left);
	
	% Change Vivid Right-hand (mm) coord. to Right-hand SPM (m) coord.
	V  = vb_vivid_mm_to_spm_right(V,mode);
	
	Coord.LV   = V  ;
	Coord.LF   = F  ;
	Coord.LX   = X  ;
	Coord.LY   = Y  ;
	Coord.Limg = img;
	
	NPL = size(V,1);
	NXL = size(X,1);
	
	fprintf('Number of points in vivid 3D-Left-image= %d\n',NPL)
	fprintf('Number of points in vivid 2D-Left-image= %d\n',NXL)
	if NPL ~= NXL, disp('# of points in 2D & 3D does not match'); end;
end

if isfield(fname ,'Right')
	[V, F, img, X, Y] = vb_read_vivid_file(fname.Right);
	
	% Change Vivid Right-hand (mm) coord. to Right-hand SPM (m) coord.
	V  = vb_vivid_mm_to_spm_right(V,mode);
	
	Coord.RV   = V  ;
	Coord.RF   = F  ;
	Coord.RX   = X  ;
	Coord.RY   = Y  ;
	Coord.Rimg = img;
	
	NPR = size(V,1);
	NXR = size(X,1);
	
	fprintf('Number of points in vivid 3D-Right-image= %d\n',NPR)
	fprintf('Number of points in vivid 2D-Right-image= %d\n',NXR)
	if NPR ~= NXR, disp('# of points in 2D & 3D does not match'); end;
end
	
if isfield(fname ,'Front')
	[V, F, img, X, Y] = vb_read_vivid_file(fname.Front);
	
	% Change Vivid Right-hand (mm) coord. to Right-hand SPM (m) coord.
	V  = vb_vivid_mm_to_spm_right(V,mode);
	
	Coord.FV   = V  ;
	Coord.FF   = F  ;
	Coord.FX   = X  ;
	Coord.FY   = Y  ;
	Coord.Fimg = img;
	
	NPF = size(V,1);
	NXF = size(X,1);
	
	fprintf('Number of points in vivid 3D-Front-image= %d\n',NPF)
	fprintf('Number of points in vivid 2D-Front-image= %d\n',NXF)
	if NPF ~= NXF, disp('# of points in 2D & 3D does not match'); end;
end
