function	[V, F, RGB] = vb_read_mgf_file(fname)
% Read MGF polyhedron data file
%  [V, F, RGB] = vb_read_mgf_file(fname)
% V   : polyhedron vertex coordinate [Npoint 3]
% F   : polyhedron patch index       [Npatch 4]
% RGB : RGB color at each vertex     [Npoint 3]
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%  ---- MGF file format
%  # Micro AVS Geom:2.00
%  polyhedron
%  UnNamed-1
%  facet
%  color
%  5820  % ĺ
%    -90.678841 89.391457 -985.069824 0.360784 0.274510 0.188235
%    ... ĺκɸ(X,Y,Z)(R,G,B)
%  5699  % ݥꥴ
%    4
%    1 79 80 2 
%    ... ĺn\ ݥꥴĺֹ

% 2006/2/2  M. Sato 

key_start  = 'color';

% Find keyward line
fid=fopen(fname);

if fid == -1, fprintf('[%s] can not be opened\n',fname);return; end;

while 1
    next_line = fgetl(fid);
    if ~ischar(next_line), break, end;
	if ~isempty( strfind(next_line,key_start)), break, end;
end

next_line = fgetl(fid);
Npoint = sscanf(next_line,'%d');

X = zeros(Npoint,6);

for n=1:Npoint
    next_line = fgetl(fid);
	x = sscanf(next_line,'%f');
	X(n,:) = x';
end

next_line = fgetl(fid);
Npatch = sscanf(next_line,'%d');

F = zeros(Npatch,4);

for n=1:Npatch
    next_line = fgetl(fid);
	num = sscanf(next_line,'%d');
	
    next_line = fgetl(fid);
	ix = sscanf(next_line,'%d');
	F(n,1:num) = ix';
	
	% If points are less than 4, duplicate first point index
	if num < 4, F(n,num+1:4) = ix(1); end;
	
end

fclose(fid);

V	= X(:,1:3);
RGB = X(:,4:6);
