function	[Vp, Xp, Yp, dmin] = vb_get_3d_point(xp,V,X,Y)
% Find nearest 3D & 2D-coordinate to the target point
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

NP   = size(xp,1);
Id   = zeros(NP,1);
dmin = zeros(NP,1);

% Find 2D-point index near the target point
for n = 1:NP
	dd = (X - xp(n,1)).^2 + (Y - xp(n,2)).^2;
	[ddmin, ix] = min(dd);
	Id(n)   = ix;
	dmin(n) = sqrt(ddmin);
end;

Vp = V(Id,:);
Xp = X(Id,:);
Yp = Y(Id,:);
