function vb_msrmnt_update_data(inst_spec)
% Replace data and update file for MEG or EEG
%
% This function is used to create/update MEG-MAT or EEG-MAT file with arbitrary
% signal preprocessing function not supported by VBMEG. 
%
% [syntax]
%   vb_msrmnt_update_data(inst_spec)
%
% [input]
%   inst_spec : <<required>> <struct> instruction spec
%       :  fields are as follows:
%       :   .org_file     : <<required>> measurement file which will be updated
%       :   .new_data     : <<required>> [n_channel x n_sample]
%       :   .channel_type : <<optional>> depend on org_file
%       :                 :  (org_file is MEG)
%       :                 :    ['MEG'] | 'AXIAL' | 'PLANAR' | 'EXTRA'
%       :                 :  (org_file is EEG)
%       :                 :    ['EEG'] | 'EXTRA'
%       :   .new_file : <<optional>> if you want to make new file.
%       :                 :  ['org_file']
%       :                 :  Empty means overwriting '.org_file'.
%       :   .bin_data_dir : <<optional>> data stored directory.
%       :                 : This parameter is valid only when 
%       :                 : '.new_file' field is set.
%       :                 : [(body of 'new_file')_bin]
%       :                 : e.g. './new_0123.meg.mat' --> './new_0123_bin'
%
% [output]
%   void
%
% [note]
%   The size of inst_spec.new_data must be the same as the original one.
% [history]
%   2011-02-09 (Sako) initial version
%   2011-06-01 (Sako) converted return values of vb_load_device to upper case
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('inst_spec', 'var'), inst_spec = []; end
[inst_spec] = inner_check_arguments(inst_spec);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
% ----- call appropriate worker
[measurement] = vb_load_device(inst_spec.org_file);
Measurement = upper(measurement);

switch Measurement
  case 'MEG'
    vb_megfile_update_data(inst_spec);
  case 'EEG'
    vb_eegfile_update_data(inst_spec);
  otherwise
    error('(%s) Measurement ''%s'' is not supported', mfilename);
end

return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [inst_spec] = inner_check_arguments(inst_spec)
func_ = mfilename;

if isempty(inst_spec)
  error('(%s) inst_spec is a required parameter', func_);
end

if ~isfield(inst_spec, 'org_file') || isempty(inst_spec.org_file)
  error('(%s) inst_spec.org_file is a required field', func_);
end

if exist(inst_spec.org_file, 'file') ~= 2
  error('(%s) cannot find inst_spec.org_file : %s', func_);
end

if ~isfield(inst_spec, 'new_data') || isempty(inst_spec.new_data)
  error('(%s) inst_spec.new_data is a required field', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
