function vb_msrmnt_update_active_flag(base_file, active_ch, active_tr, new_file)
% update active flags and make new file if you want
% [usage]
%   vb_msrmnt_update_active_flag(base_file, active_ch, active_tr, new_file)
% [input]
%   base_file : <required> <<file>> base file (.meg.mat or .eeg.mat)
%   active_ch : <optional> [Nchannel x 1 boolean] [[]]
%             :  if this is given, MEG(EEG)info.ActiveChannel will be updated
%   active_tr : <optional> [Ntrial x 1 boolean] [[]]
%             :  if this is given, MEG(EEG)info.ActiveTrial will be updated
%    new_file : <optional> <<file>> new file name ['']
%             :  if this is empty, base_file will be over-written
% [output]
%   none
% [note]
%
% [history]
%   2009-07-07 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('base_file', 'var'), base_file = ''; end
if ~exist('active_ch', 'var'), active_ch = []; end
if ~exist('active_tr', 'var'), active_tr = []; end
if ~exist('new_file',  'var'), new_file = '';  end
[base_file, active_ch, active_tr, new_file] = ...
  inner_check_arguments(base_file, active_ch, active_tr, new_file);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
info = vb_load_measurement_info(base_file);
n_channel = vb_info_get_Nchannel(info);
n_trial   = vb_info_get_Nrepeat(info);

if ~isempty(active_ch)
  act_len = size(active_ch, 1);
  if act_len ~= n_channel
    warning('(%s)length of active_ch (%d) ~= n_channel(%d)\n', ...
      mfilename, act_len, n_channel);
    fprintf('(%s)ActiveChannel has not been updated\n', mfilename);
  else
    info = vb_info_set_active_channel(info, active_ch);
  end
end

if ~isempty(active_tr)
  act_len = size(active_tr, 1);
  if act_len ~= n_trial
    warning('(%s)length of active_tr (%d) ~= n_trial(%d)\n', ...
      mfilename, act_len, n_trial);
    fprintf('(%s)ActiveTrial has not been updated\n', mfilename);
  else
    info = vb_info_set_active_trial(info, active_tr);
  end
end

% --- make new file
if ~isempty(new_file)
  org_data = load(base_file);
  measurement = vb_info_get_measurement(info);
  
  switch measurement
    case 'MEG'
      org_data.MEGinfo = info;
    case 'EEG'
      org_data.EEGinfo = info;
    otherwise
      error('(%s) unknown measurement : %s', mfilename, measurement);
  end
  
  vb_save_struct(new_file, org_data);

end
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [base_file, active_ch, active_tr, new_file] = ...
  inner_check_arguments(base_file, active_ch, active_tr, new_file)
func_ = mfilename;

if isempty(base_file)
  error('(%s) base_file is a required parameter', func_);
end

if exist(base_file, 'file') ~= 2
  error('(%s) cannot find base_file : %s', func_, base_file);
end

if isempty(active_ch)
  % nothing to do
end

if isempty(active_tr)
  % nothing to do
end

if isempty(new_file)
  new_file = base_file;
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
