function vb_msrmnt_set_spherical_data( msrmnt_file, sph_data )
% set spherical data (Vcenter, Vradius) to a .meg.mat file or .eeg.mat file
% [usage]
%   vb_msrmnt_set_spherical_data( msrmnt_file, sph_data )
% [input]
%   msrmnt_file : <required> <<file>> target file (.meg.mat or .eeg.mat)
%      sph_data : <required> <<struct>> data of spherical model
%                 following fields are required.
%                  .Vcenter : (x,y,z) center coordinate of the spherical model
%                  .Vradius : [m] radius of the spherical model
% [output]
%   none
% [note]
%   updated fields are .Vcenter and .Vradius of MEGinfo or EEGinfo
% [history]
%   2011-05-30 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('msrmnt_file', 'var'), msrmnt_file = ''; end
if ~exist('sph_data', 'var'), sph_data = []; end
[msrmnt_file, sph_data] = inner_check_arguments(msrmnt_file, sph_data);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
[measurement] = vb_load_device(msrmnt_file);
Measurement = upper(measurement);

msrmnt = load(msrmnt_file);

switch Measurement
  case 'MEG'
    if isfield(sph_data, 'Vcenter')
      msrmnt.MEGinfo.Vcenter = sph_data.Vcenter;
    end
  
    if isfield(sph_data, 'Vradius')
      msrmnt.MEGinfo.Vradius = sph_data.Vradius;
    end

  case 'EEG'
    if isfield(sph_data, 'Vcenter')
      msrmnt.EEGinfo.Vcenter = sph_data.Vcenter;
    end
  
    if isfield(sph_data, 'Vradius')
      msrmnt.EEGinfo.Vradius = sph_data.Vradius;
    end

  otherwise
    warning('%s is unknown measurement\n', Measurement);
    return;
end

vb_save_struct(msrmnt_file, msrmnt);
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [msrmnt_file, sph_data] = inner_check_arguments(msrmnt_file, sph_data)
func_ = mfilename;

if isempty(msrmnt_file)
  error('(%s) msrmnt_file is a required parameter', func_);
end
if exist(msrmnt_file, 'file') ~= 2
  error('(%s) cannot be found msrmnt_file : %s', func_, msrmnt_file);
end

if isempty(sph_data)
  error('(%s) sph_data is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %


