function sampling_frequency = vb_msrmnt_get_sampling_frequency(measurement_file)
% return sampling frequency from measurement file
% [usage]
%   sampling_frequency = vb_msrmnt_get_sampling_frequency(measurement_file)
% [input]
%   measurement_file : <required> measurement file path
%                    :  e.g. EEG-MAT (.eeg.mat), MEG-MAT (.meg.mat)
% [output]
%   sampling_frequency : sampling frequency
% [note]
%   acceptable 'Measurement' are :
%   'MEG', 'EEG'
% [history]
%   2007-08-02 (Sako) initial version
%   2011-06-01 (Sako) converted return values of vb_load_device to upper case
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('measurement_file', 'var') measurement_file = []; end;
measurement_file = inner_check_arguments(measurement_file);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
func_ = mfilename;
sampling_frequency = [];

[measurement] = vb_load_device(measurement_file);
Measurement = upper(measurement);

switch Measurement
  case  'MEG'
    sampling_frequency = vb_megfile_get_sampling_frequency(measurement_file);
  case  'EEG'
    sampling_frequency = vb_eegfile_get_sampling_frequency(measurement_file);
  otherwise
    error('(%s)unexpected Measurement type : %s', func_, Measurement);
end
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function measurement_file = inner_check_arguments(measurement_file)
func_ = mfilename;
if isempty(measurement_file)
  error('(%s)measurement_file is a required parameter', func_);
end

if exist(measurement_file, 'file') ~= 2
  error('(%s)cannot find measurement file : %s', func_, measurement_file);
end
return;
%
% --- end of inner_check_arguments()

% --- END OF FILE --- %
