function [samples] = vb_loadspec_make_trial_sample(loadspec)
% make list of start-end samples from LoadSpec
% [usage]
%   [samples] = vb_loadspec_make_trial_sample(loadspec)
% [input]
%   loadspec : <required> <<struct>> LoadSpec
%            :  .Trigger : [Ntrial x1 double] sample number list of trigger
%            :  .Pretrigger : [x1 double] number of sample before trigger 
%            :  .Posttrigger : [x1 double] number of sample after trigger
%            :  .TrialNumber : [Ntrial x1 double] trial index list
% [output]
%    samples : [Ntrial x 2] list of from-to
%            :  if trigger data in loadspec is invalid, return empty
% [note]
%
% [history]
%   2008-02-29 (Sako) initial version
%   2009-07-28 (Sako) modified to return empty if trigger data is invalid
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('loadspec', 'var'), loadspec = []; end
[trigger, pretrigger, posttrigger] = inner_check_arguments(loadspec);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if isempty(trigger) || isempty(pretrigger) || isempty(posttrigger)
  samples = [];
  return;
end

samples = [(trigger-pretrigger), (trigger+posttrigger)];
return
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [trigger, pretrigger, posttrigger] = inner_check_arguments(loadspec)
func_ = mfilename;

trigger = [];
pretrigger = [];
posttrigger = [];
if isempty(loadspec)
%   fprintf('(%s)loadspec is a required parameter\n', func_);
  return;
end

if ~isfield(loadspec, 'Trigger') || isempty(loadspec.Trigger) ...
    || ~isfield(loadspec, 'Pretrigger') || isempty(loadspec.Pretrigger) ...
    || ~isfield(loadspec, 'Posttrigger') || isempty(loadspec.Posttrigger)
%   fprintf('(%s)invalid trigger in loadspec\n', func_);
  return;
end

trigger = vb_util_arrange_list(loadspec.Trigger);
pretrigger = loadspec.Pretrigger;
posttrigger = loadspec.Posttrigger;
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
