function info = vb_info_set_post_trigger(info, value)
% info setter : post-trigger
% [usage]
%   info = vb_info_set_post_trigger(info, value)
% [input]
%    info : <required> <<struct>> MEGinfo or EEGinfo or other (unexpected)
%   value : <optional> set value []
% [output]
%    info : updated info
% [note]
%   @see vb_meginfo_set_post_trigger.m
%   @see vb_eeginfo_set_post_trigger.m
% [history]
%   2007-08-02 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('info', 'var') info = []; end
if ~exist('value', 'var') value = []; end
[info, value] = inner_check_arguments(info, value);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
func_ = mfilename;
my_measurement = vb_info_get_measurement(info);

switch my_measurement
  case  'EEG'
    info = vb_eeginfo_set_post_trigger(info, value);
  case  'MEG'
    info = vb_meginfo_set_post_trigger(info, value);
  otherwise
    error('(%s)unexpected measurement : %s', func_, my_measurement);
end
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [info, value] = inner_check_arguments(info, value)
func_ = mfilename;
if isempty(info)
  error('(%s)info is a required parameter', func_);
end

if isempty(value)
  % require no action - relegate setting default value to particular functions
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
