function info = vb_info_set_channel_info(info, channel_info)
% set channel info field to the appropriate field name
% [usage]
%   info = vb_info_set_channel_info(info, channel_info)
% [input]
%   info : <required> <<struct>> MEGinfo or EEGinfo
%   channel_info : <required> <<struct>> which has fields as follows
%                :  .Active [Nchannel x 1 boolean]
%                :  .Name   {Nchannel x 1}
%                :  .Type   [Nchannel x 1]
%                :  .ID     [Nchannel x 1]
%                : if this is empty, empty data is set to the info
% [output]
%   info : updated info (MEGinfo or EEGinfo)
% [note]
%
% [history]
%   2009-07-07 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('info', 'var'), info = []; end
if ~exist('channel_info', 'var'), channel_info = []; end
[info, channel_info] = inner_check_arguments(info, channel_info);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
info.ChannelInfo = channel_info;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [info, channel_info] = inner_check_arguments(info, channel_info)
func_ = mfilename;
if isempty(info)
  error('(%s) info is a required parameter', func_);
end

if isempty(channel_info)
  % require no action
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
