function [info, result] = vb_info_set_active_trial(info, active_trial)
% <<setter>> set active trial value to info (MEGinfo or EEGinfo)
% [usage]
%   [info] = vb_info_set_active_trial(info, active_trial)
% [input]
%           info : <required> <<struct>> info
%   active_trial : <required> [Ntrial x 1]
% [output]
%           info : updated info
%                :  newly added field is .ActiveTrial [Ntrial x 1 boolean]
%         result :  0) success
%                :  1) failure - info is invalid
%                :  2) failure - active_trial is empty
%                :  4) failure - different lengths
% [note]
%   If the length of active_trial is different from number of all the trial,
%   this function does not set new value
%   @see vb_info_set_active_flag
% [history]
%   2008-04-11 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('info', 'var'), info = []; end
if ~exist('active_trial', 'var'), active_trial = []; end
[info, active_trial, result] = inner_check_arguments(info, active_trial);

if result ~= 0
  return;
end

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
info.ActiveTrial = active_trial;
info = vb_info_set_active_flag(info, active_trial);
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [info, active_trial, err_code] = ...
  inner_check_arguments(info, active_trial)
func_ = mfilename;
err_code = 0;
if isempty(info)
  fprintf('(%s)info is a required parameter\n', func_);
  err_code = bitor(err_code,1);
end

if isempty(active_trial)
  fprintf('(%s)active_trial is a required parameter\n', func_);
  err_code = bitor(err_code, 2);
end

if err_code ~= 0
  return;
end

% ----- check length
n_trial = vb_info_get_trial_number(info, false);
n_active  = length(active_trial);

if n_trial ~= n_active
  fprintf('(%s)lengths are different', func_);
  fprintf(' - active_trial (%d) and number of trial (%d)\n', ...
    n_active, n_trial);
  err_code = bitor(err_code, 4);
end

% --- [N x 1]
active_trial = vb_util_arrange_list(active_trial);
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
