function [info, result] = vb_info_set_active_channel(info, active_channel)
% <<setter>> set active_channel value to info (MEGinfo or EEGinfo)
% [usage]
%   [info] = vb_info_set_active_channel(info, active_channel)
% [input]
%              info : <required> <<struct>> MEGinfo or EEGinfo
%    active_channel : <required> [Nchannel x 1]
% [output]
%              info : updated info
%                   :  newly added field is ActiveChannel [Nchannel x 1 boolean]
%            result :  0) success
%                   :  1) failure - info is invalid
%                   :  2) failure - active_channel is empty
%                   :  4) failure - different lengths
% [note]
%   If the length of active_channel is different from the number of all the
%   channel, this function does not update info.
% [history]
%   2008-04-11 (Sako) initial version
%   2009-07-07 (Sako) modified to update info.ChannelInfo.Active
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('info', 'var'), info = []; end
if ~exist('active_channel', 'var'), active_channel = []; end
[info, active_channel, result] = ...
  inner_check_arguments(info, active_channel);

if result ~= 0
  return;
end

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
info.ActiveChannel = active_channel;
info.ChannelInfo.Active = info.ActiveChannel;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [info, active_channel, err_code] = ...
  inner_check_arguments(info, active_channel)
func_ = mfilename;
err_code = 0;
if isempty(info)
  fprintf('(%s)info is a required parameter\n', func_);
  err_code = bitor(err_code,1);
end

if isempty(active_channel)
%   fprintf('(%s)active_channel is a required parameter\n', func_);
%   err_code = bitor(err_code, 2);
end

if err_code ~= 0
  return;
end

% ----- check length
n_channel = vb_info_get_Nchannel(info);
n_active  = length(active_channel);

if n_channel ~= n_active
  fprintf('(%s)numbers are different', func_);
  fprintf(' - active_channel (%d) and number of channel (%d)\n', ...
    n_active, n_channel);
  err_code = bitor(err_code, 4);
end

% arrange to [N x 1]
if ~isempty(active_channel)
  active_channel = vb_util_arrange_list(active_channel);
end

return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
